/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.actions.SaveAction;
import tiled.mapeditor.actions.SaveAsAction;

public abstract class AbstractFileAction
extends AbstractAction {
    protected final MapEditor editor;
    private final SaveAsAction saveAction;
    private static final String SAVE_CHANGES_TEXT = Resources.getString("action.map.save.changes.text");
    private static final String SAVE_CHANGES_TITLE = Resources.getString("action.map.save.changes.title");

    protected AbstractFileAction(MapEditor editor, SaveAction saveAction, String name, String description) {
        super(name);
        this.editor = editor;
        this.saveAction = saveAction;
        this.putValue("ShortDescription", description);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        if (this.editor.unsavedChanges()) {
            int ret = JOptionPane.showConfirmDialog(this.editor.getAppFrame(), SAVE_CHANGES_TEXT, SAVE_CHANGES_TITLE, 1);
            if (ret == 0) {
                this.saveAction.actionPerformed(e);
                if (!this.saveAction.isSavingCancelled() && !this.editor.unsavedChanges()) {
                    this.doPerformAction();
                }
            } else if (ret == 1) {
                this.doPerformAction();
            }
        } else {
            this.doPerformAction();
        }
    }

    protected abstract void doPerformAction();
}

